<?php
require_once 'config.php';

// Get video ID from URL
$videoId = $_GET['id'] ?? '';

if (empty($videoId)) {
    header('Location: index.php');
    exit;
}

// Get video from database
$stmt = $pdo->prepare("SELECT * FROM videos WHERE video_id = ?");
$stmt->execute([$videoId]);
$video = $stmt->fetch();

if (!$video) {
    header('Location: index.php');
    exit;
}

// Update view count
$stmt = $pdo->prepare("UPDATE videos SET views = views + 1 WHERE video_id = ?");
$stmt->execute([$videoId]);

$videoUrl = SITE_URL . '/uploads/' . $video['filename'];
$shareUrl = SITE_URL . '/video.php?id=' . $videoId;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($video['original_name']); ?> - Videyt</title>
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo htmlspecialchars($video['original_name']); ?>">
    <meta property="og:type" content="video.other">
    <meta property="og:url" content="<?php echo $shareUrl; ?>">
    <meta property="og:video" content="<?php echo $videoUrl; ?>">
    <meta property="og:video:type" content="<?php echo $video['mime_type']; ?>">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="player">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($video['original_name']); ?>">
    <meta name="twitter:player" content="<?php echo $videoUrl; ?>">
    
    <!-- Popunder Script -->
    <script>document.write(atob("PHNjcmlwdCB0eXBlPSd0ZXh0L2phdmFzY3JpcHQnIHNyYz0nLy9ydXRjb21wb3N1cmVvcHQuY29tLzQyLzEwL2VjLzQyMTBlYzYzYmU4OTE3MzgwODU1ZDdmNDFiNjkxN2RkLmpzJz48L3NjcmlwdD4="));</script>
    
    <style>
        /* Style untuk container video yang responsif */
        .video-container {
            display: flex;
            justify-content: center;
            align-items: center;
            background: black;
            border-radius: 12px;
            overflow: hidden;
        }
        
        .video-container video {
            max-width: 100%;
            max-height: 80vh;
            width: auto;
            height: auto;
        }
        
        /* Hide scrollbar for Chrome, Safari and Opera */
        .scrollbar-hide::-webkit-scrollbar {
            display: none;
        }
        
        /* Hide scrollbar for IE, Edge and Firefox */
        .scrollbar-hide {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
    </style>
</head>
<body class="bg-white">
    
    <!-- Header -->
    <header class="bg-white border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between max-w-7xl mx-auto">
            <div class="flex items-center gap-4">
                <a href="index.php" class="text-2xl font-bold hover:text-gray-700">Videyt</a>
                <a href="index.php" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 rounded-full text-sm font-medium transition-colors">
                    Upload
                </a>
            </div>
            <a href="admin.php" class="text-sm text-gray-600 hover:text-gray-900">Admin</a>
        </div>
    </header>

    <!-- Folder Navigation -->
    <div class="bg-white border-b border-gray-200 px-4 py-6">
        <div class="max-w-7xl mx-auto">
            <!-- Desktop & Tablet: Horizontal Layout -->
            <div class="hidden sm:flex items-center justify-center gap-6 lg:gap-8">
                <a href="?category=jepang" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity">
                    <div class="w-14 h-14 lg:w-16 lg:h-16 flex items-center justify-center">
                        <svg width="56" height="56" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Jepang</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity">
                    <div class="w-14 h-14 lg:w-16 lg:h-16 flex items-center justify-center">
                        <svg width="56" height="56" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Indo</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity">
                    <div class="w-14 h-14 lg:w-16 lg:h-16 flex items-center justify-center">
                        <svg width="56" height="56" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Chindo</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity">
                    <div class="w-14 h-14 lg:w-16 lg:h-16 flex items-center justify-center">
                        <svg width="56" height="56" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Hijab</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity">
                    <div class="w-14 h-14 lg:w-16 lg:h-16 flex items-center justify-center">
                        <svg width="56" height="56" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Viral</span>
                </a>
            </div>

            <!-- Mobile: Scrollable Horizontal Layout -->
            <div class="flex sm:hidden overflow-x-auto gap-6 pb-2 scrollbar-hide">
                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity flex-shrink-0">
                    <div class="w-14 h-14 flex items-center justify-center">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-xs font-medium text-gray-700">Jepang</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity flex-shrink-0">
                    <div class="w-14 h-14 flex items-center justify-center">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-xs font-medium text-gray-700">Indo</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity flex-shrink-0">
                    <div class="w-14 h-14 flex items-center justify-center">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-xs font-medium text-gray-700">Chindo</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity flex-shrink-0">
                    <div class="w-14 h-14 flex items-center justify-center">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-xs font-medium text-gray-700">Hijab</span>
                </a>

                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" class="flex flex-col items-center gap-2 hover:opacity-80 transition-opacity flex-shrink-0">
                    <div class="w-14 h-14 flex items-center justify-center">
                        <svg width="52" height="52" viewBox="0 0 24 24" fill="#93C5FD" stroke="#60A5FA" stroke-width="0.5">
                            <path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/>
                        </svg>
                    </div>
                    <span class="text-xs font-medium text-gray-700">Viral</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Video Player -->
    <main class="max-w-4xl mx-auto px-6 py-8">
        <div class="video-container mb-6">
            <video id="videoPlayer" controls autoplay>
                <source src="<?php echo $videoUrl; ?>" type="<?php echo $video['mime_type']; ?>">
                Your browser does not support the video tag.
            </video>
        </div>

        <!-- Video Info -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold mb-2"><?php echo htmlspecialchars($video['original_name']); ?></h1>
            <p class="text-gray-600 text-sm">
                <?php echo number_format($video['views']); ?> views • 
                <?php echo formatBytes($video['file_size']); ?> • 
                Uploaded <?php echo date('M d, Y', strtotime($video['uploaded_at'])); ?>
            </p>
        </div>

        <!-- Download Buttons -->
        <div class="mb-6 px-4">
            <div class="flex flex-col gap-3 max-w-md mx-auto">
                <!-- Tombol 480p - Ganti URL di href="" dengan direct link Anda -->
                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" target="_blank" class="flex items-center gap-3 bg-black hover:bg-gray-800 text-white px-6 py-4 rounded-2xl transition-colors">
                    <svg class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="7 10 12 15 17 10"></polyline>
                        <line x1="12" y1="15" x2="12" y2="3"></line>
                    </svg>
                    <div class="text-left">
                        <div class="font-semibold">Download</div>
                        <div class="text-sm opacity-90">480p</div>
                    </div>
                </a>

                <!-- Tombol 720p - Ganti URL di href="" dengan direct link Anda -->
                <a href="https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f" target="_blank" class="flex items-center gap-3 bg-black hover:bg-gray-800 text-white px-6 py-4 rounded-2xl transition-colors">
                    <svg class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="7 10 12 15 17 10"></polyline>
                        <line x1="12" y1="15" x2="12" y2="3"></line>
                    </svg>
                    <div class="text-left">
                        <div class="font-semibold">Download</div>
                        <div class="text-sm opacity-90">720p</div>
                    </div>
                </a>

                <!-- Tombol 1080p - Tetap menggunakan video URL asli -->
                <a href="<?php echo $videoUrl; ?>" download class="flex items-center gap-3 bg-black hover:bg-gray-800 text-white px-6 py-4 rounded-2xl transition-colors">
                    <svg class="w-4 h-4 sm:w-6 sm:h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="7 10 12 15 17 10"></polyline>
                        <line x1="12" y1="15" x2="12" y2="3"></line>
                    </svg>
                    <div class="text-left">
                        <div class="font-semibold">Download</div>
                        <div class="text-[15px] sm:text-sm opacity-90">1080p</div>
                    </div>
                </a>
            </div>
        </div>
        
        <!-- Share Options -->
        <div class="text-center border-t pt-6">
            <p class="text-sm text-gray-600 mb-4">Share this video</p>
            
            <div class="flex gap-3 mb-6 max-w-xl mx-auto">
                <input type="text" id="shareLink" value="<?php echo $shareUrl; ?>" readonly class="flex-1 px-4 py-3 border border-gray-300 rounded-xl text-sm">
                <button onclick="copyLink()" class="px-6 py-3 bg-gray-100 hover:bg-gray-200 rounded-xl font-medium transition-colors">
                    Copy
                </button>
            </div>

            <div class="flex items-center justify-center gap-6">
                <button onclick="shareOnWhatsApp()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path>
                        </svg>
                    </div>
                    <span class="text-xs">WhatsApp</span>
                </button>
                
                <button onclick="shareOnFacebook()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                        </svg>
                    </div>
                    <span class="text-xs">Facebook</span>
                </button>

                <button onclick="shareOnTwitter()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z"></path>
                        </svg>
                    </div>
                    <span class="text-xs">Twitter</span>
                </button>

                <button onclick="shareViaEmail()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                            <polyline points="22,6 12,13 2,6"></polyline>
                        </svg>
                    </div>
                    <span class="text-xs">Email</span>
                </button>
            </div>
        </div>
    </main>

    <script>
        const shareUrl = '<?php echo $shareUrl; ?>';
        const videoTitle = '<?php echo addslashes($video['original_name']); ?>';

        // Fungsi untuk mendeteksi orientasi video dan mengatur tampilan
        const videoPlayer = document.getElementById('videoPlayer');
        
        videoPlayer.addEventListener('loadedmetadata', function() {
            const videoWidth = this.videoWidth;
            const videoHeight = this.videoHeight;
            const aspectRatio = videoWidth / videoHeight;
            
            // Jika video portrait (tinggi > lebar)
            if (aspectRatio < 1) {
                this.style.maxWidth = '50vh'; // Batasi lebar untuk video portrait
                this.style.maxHeight = '80vh';
            } else {
                // Video landscape
                this.style.maxWidth = '100%';
                this.style.maxHeight = '80vh';
            }
        });

        // Popunder Script - Trigger setiap 30 detik
        let lastPopunderTime = -30; // Start dengan -30 agar bisa trigger di detik 0
        const popunderInterval = 30; // 30 detik
        
        function triggerPopunder() {
            // Trigger click event untuk activate popunder
            document.body.click();
        }
        
        // Monitor waktu pemutaran video
        videoPlayer.addEventListener('timeupdate', function() {
            const currentTime = Math.floor(this.currentTime);
            
            // Cek apakah sudah lewat 30 detik dari popunder terakhir
            if (currentTime - lastPopunderTime >= popunderInterval) {
                triggerPopunder();
                lastPopunderTime = currentTime;
            }
        });
        
        // Trigger popunder pertama kali saat video di play
        let firstPlay = true;
        videoPlayer.addEventListener('play', function() {
            if (firstPlay) {
                setTimeout(function() {
                    triggerPopunder();
                }, 500);
                firstPlay = false;
                lastPopunderTime = 0;
            }
        });

        function copyLink() {
            const linkInput = document.getElementById('shareLink');
            linkInput.select();
            document.execCommand('copy');
            alert('Link copied to clipboard!');
        }

        function shareOnWhatsApp() {
            window.open('https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f' + encodeURIComponent(videoTitle + ' - ' + shareUrl), '_blank');
        }

        function shareOnFacebook() {
            window.open('https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f' + encodeURIComponent(shareUrl), '_blank');
        }

        function shareOnTwitter() {
            window.open('https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f' + encodeURIComponent(shareUrl) + '&text=' + encodeURIComponent(videoTitle), '_blank');
        }

        function shareViaEmail() {
            window.location.href = 'https://rutcomposureopt.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f' + encodeURIComponent(videoTitle) + '&body=' + encodeURIComponent(shareUrl);
        }
    </script>
    <?php include 'includes/telegram-float.php'; ?>
    <?php include 'includes/floating-banner.php'; ?>

</body>
</html>