<?php
require_once 'config.php';

// Get video ID from URL
$videoId = $_GET['id'] ?? '';

if (empty($videoId)) {
    header('Location: index.php');
    exit;
}

// Get video from database
$stmt = $pdo->prepare("SELECT * FROM videos WHERE video_id = ?");
$stmt->execute([$videoId]);
$video = $stmt->fetch();

if (!$video) {
    header('Location: index.php');
    exit;
}

// Update view count
$stmt = $pdo->prepare("UPDATE videos SET views = views + 1 WHERE video_id = ?");
$stmt->execute([$videoId]);

$videoUrl = SITE_URL . '/uploads/' . $video['filename'];
$shareUrl = SITE_URL . '/video.php?id=' . $videoId;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<script type='text/javascript' src='//pl27691219.effectivegatecpm.com/12/e3/50/12e350729ac244f453464758ab10cbb2.js'></script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($video['original_name']); ?> - Videyt</title>
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo htmlspecialchars($video['original_name']); ?>">
    <meta property="og:type" content="video.other">
    <meta property="og:url" content="<?php echo $shareUrl; ?>">
    <meta property="og:video" content="<?php echo $videoUrl; ?>">
    <meta property="og:video:type" content="<?php echo $video['mime_type']; ?>">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="player">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($video['original_name']); ?>">
    <meta name="twitter:player" content="<?php echo $videoUrl; ?>">
</head>
<body class="bg-white">
    <!-- Header -->
    <header class="bg-white border-b border-gray-200 px-6 py-4">
        <div class="flex items-center justify-between max-w-7xl mx-auto">
            <div class="flex items-center gap-4">
                <a href="index.php" class="text-2xl font-bold hover:text-gray-700">Videyt</a>
                <a href="index.php" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 rounded-full text-sm font-medium transition-colors">
                    Upload
                </a>
            </div>
            <a href="admin.php" class="text-sm text-gray-600 hover:text-gray-900">Admin</a>
        </div>
    </header>

    <!-- Video Player -->
    <main class="max-w-4xl mx-auto px-6 py-8">
        <div class="bg-black rounded-xl overflow-hidden mb-6">
            <video controls autoplay class="w-full aspect-video">
                <source src="<?php echo $videoUrl; ?>" type="<?php echo $video['mime_type']; ?>">
                Your browser does not support the video tag.
            </video>
        </div>

        <!-- Video Info -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold mb-2"><?php echo htmlspecialchars($video['original_name']); ?></h1>
            <p class="text-gray-600 text-sm">
                <?php echo number_format($video['views']); ?> views • 
                <?php echo formatBytes($video['file_size']); ?> • 
                Uploaded <?php echo date('M d, Y', strtotime($video['uploaded_at'])); ?>
            </p>
        </div>

        <!-- Share Options -->
        <div class="text-center border-t pt-6">
            <p class="text-sm text-gray-600 mb-4">Share this video</p>
            
            <div class="flex gap-3 mb-6 max-w-xl mx-auto">
                <input type="text" id="shareLink" value="<?php echo $shareUrl; ?>" readonly class="flex-1 px-4 py-3 border border-gray-300 rounded-xl text-sm">
                <button onclick="copyLink()" class="px-6 py-3 bg-gray-100 hover:bg-gray-200 rounded-xl font-medium transition-colors">
                    Copy
                </button>
            </div>

            <div class="flex items-center justify-center gap-6">
                <button onclick="shareOnWhatsApp()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path>
                        </svg>
                    </div>
                    <span class="text-xs">WhatsApp</span>
                </button>
                
                <button onclick="shareOnFacebook()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path>
                        </svg>
                    </div>
                    <span class="text-xs">Facebook</span>
                </button>

                <button onclick="shareOnTwitter()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z"></path>
                        </svg>
                    </div>
                    <span class="text-xs">Twitter</span>
                </button>

                <button onclick="shareViaEmail()" class="flex flex-col items-center gap-2 text-gray-600 hover:text-gray-900">
                    <div class="w-10 h-10 bg-gray-100 rounded-full flex items-center justify-center">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                            <polyline points="22,6 12,13 2,6"></polyline>
                        </svg>
                    </div>
                    <span class="text-xs">Email</span>
                </button>
            </div>
        </div>
    </main>

    <script>
        const shareUrl = '<?php echo $shareUrl; ?>';
        const videoTitle = '<?php echo addslashes($video['original_name']); ?>';

        function copyLink() {
            const linkInput = document.getElementById('shareLink');
            linkInput.select();
            document.execCommand('copy');
            alert('Link copied to clipboard!');
        }

        function shareOnWhatsApp() {
            window.open('https://wa.me/?text=' + encodeURIComponent(videoTitle + ' - ' + shareUrl), '_blank');
        }

        function shareOnFacebook() {
            window.open('https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent(shareUrl), '_blank');
        }

        function shareOnTwitter() {
            window.open('https://twitter.com/intent/tweet?url=' + encodeURIComponent(shareUrl) + '&text=' + encodeURIComponent(videoTitle), '_blank');
        }

        function shareViaEmail() {
            window.location.href = 'mailto:?subject=' + encodeURIComponent(videoTitle) + '&body=' + encodeURIComponent(shareUrl);
        }
    </script>
	<script type="text/javascript">
	atOptions = {
		'key' : '58897f7f2e0337280fec1135f25e1ee2',
		'format' : 'iframe',
		'height' : 50,
		'width' : 320,
		'params' : {}
	};
</script>
<script type="text/javascript" src="//www.highperformanceformat.com/58897f7f2e0337280fec1135f25e1ee2/invoke.js"></script>
	<script type='text/javascript' src='//pl27691283.effectivegatecpm.com/2e/46/c0/2e46c07eab34dbc505d9614486a249d0.js'></script>
   <script async="async" data-cfasync="false" src="//pl27690911.effectivegatecpm.com/bc546381420df925a83f6bbc8b2ec312/invoke.js"></script>
<div id="container-bc546381420df925a83f6bbc8b2ec312"></div>
</body>
</html>