<?php
require_once 'config.php';

header('Content-Type: application/json');
set_time_limit(0);

// Get input
$videoId = $_POST['video_id'] ?? '';
$sourceUrl = rtrim($_POST['source_url'] ?? 'https://videy.co', '/');

if (empty($videoId)) {
    echo json_encode(['success' => false, 'message' => 'Video ID is required']);
    exit;
}

// Validate Video ID format
if (!preg_match('/^[a-zA-Z0-9]+$/', $videoId)) {
    echo json_encode(['success' => false, 'message' => 'Invalid Video ID format']);
    exit;
}

// Generate job ID
$jobId = 'clone_' . time() . '_' . substr(md5($videoId), 0, 8);

// Create jobs directory
$jobsDir = __DIR__ . '/jobs/';
if (!is_dir($jobsDir)) {
    mkdir($jobsDir, 0755, true);
}

// Construct video URL from source
// Format: https://videy.co/v/?id=abc123
$videoPageUrl = $sourceUrl . '/v/?id=' . $videoId;

// Save job info
$jobFile = $jobsDir . $jobId . '.json';
$jobData = [
    'job_id' => $jobId,
    'original_video_id' => $videoId,
    'source_url' => $sourceUrl,
    'video_page_url' => $videoPageUrl,
    'status' => 'pending',
    'progress' => 0,
    'created_at' => date('Y-m-d H:i:s')
];

file_put_contents($jobFile, json_encode($jobData));

// Start background clone process
$command = sprintf(
    'php %s %s > /dev/null 2>&1 &',
    escapeshellarg(__DIR__ . '/clone-worker.php'),
    escapeshellarg($jobId)
);

if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
    pclose(popen("start /B " . $command, "r"));
} else {
    exec($command);
}

echo json_encode([
    'success' => true,
    'job_id' => $jobId,
    'message' => 'Clone process started'
]);
?>