<?php
require_once 'config.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (isLoggedIn()) {
    header('Location: admin.php');
    exit;
}

$error = '';
$debug_info = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    $debug_info[] = "Form submitted";
    $debug_info[] = "Username: " . htmlspecialchars($username);
    $debug_info[] = "Password length: " . strlen($password);

    if (!empty($username) && !empty($password)) {
        try {
            $stmt = $pdo->prepare("SELECT * FROM admin WHERE username = ?");
            $stmt->execute([$username]);
            $admin = $stmt->fetch();
            
            $debug_info[] = "Query executed";
            
            if ($admin) {
                $debug_info[] = "User found in database";
                $debug_info[] = "Stored hash: " . substr($admin['password'], 0, 20) . "...";
                
                // Test password
                $isValid = password_verify($password, $admin['password']);
                $debug_info[] = "Password verify result: " . ($isValid ? 'TRUE' : 'FALSE');
                
                if ($isValid) {
                    $_SESSION['admin_logged_in'] = true;
                    $_SESSION['admin_id'] = $admin['id'];
                    $_SESSION['admin_username'] = $admin['username'];
                    
                    $debug_info[] = "Session set successfully";
                    
                    header('Location: admin.php');
                    exit;
                } else {
                    $error = 'Invalid password';
                    $debug_info[] = "Password mismatch";
                }
            } else {
                $error = 'User not found';
                $debug_info[] = "User not found in database";
            }
        } catch (PDOException $e) {
            $error = 'Database error: ' . $e->getMessage();
            $debug_info[] = "Database error: " . $e->getMessage();
        }
    } else {
        $error = 'Please enter username and password';
        $debug_info[] = "Empty username or password";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Videy</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen flex items-center justify-center px-4">
        <div class="max-w-md w-full">
            <div class="text-center mb-8">
                <h1 class="text-3xl font-bold mb-2">Admin Login</h1>
                <p class="text-gray-600">Sign in to access admin panel</p>
            </div>

            <div class="bg-white rounded-2xl shadow-lg p-8">
                <?php if ($error): ?>
                    <div class="mb-6 p-4 bg-red-50 border border-red-200 text-red-700 rounded-lg">
                        <?php echo htmlspecialchars($error); ?>
                    </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Username</label>
                        <input type="text" name="username" required 
                               value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent" 
                               placeholder="Enter username"
                               autocomplete="off">
                    </div>

                    <div class="mb-6">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                        <input type="password" name="password" required 
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent" 
                               placeholder="Enter password"
                               autocomplete="off">
                    </div>

                    <button type="submit" class="w-full py-3 bg-black text-white rounded-lg font-medium hover:bg-gray-800 transition-colors">
                        Login
                    </button>
                </form>

                <div class="mt-6 text-center">
                    <a href="index.php" class="text-sm text-gray-600 hover:text-gray-900">← Back to Home</a>
                </div>
            </div>

            <div class="mt-6 text-center text-sm text-gray-600">
                <p>Default credentials:</p>
                <p class="font-mono bg-gray-100 inline-block px-3 py-1 rounded mt-2">admin / admin123</p>
            </div>
            
            <!-- Debug Info (hapus setelah berhasil) -->
            <?php if (!empty($debug_info)): ?>
                <div class="mt-6 bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                    <h3 class="font-bold text-yellow-800 mb-2">🐛 Debug Info:</h3>
                    <ul class="text-sm text-yellow-700 space-y-1">
                        <?php foreach ($debug_info as $info): ?>
                            <li>• <?php echo htmlspecialchars($info); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>