/*
	| -------------------------------------------------------------------------------
	| Author            : Manse
	| Template Name     : Videy
	| Whatsapp          : 085178499121
	| -------------------------------------------------------------------------------

<?php
session_start();

// Create jobs directory
define('JOBS_DIR', __DIR__ . '/jobs/');
if (!is_dir(JOBS_DIR)) {
    mkdir(JOBS_DIR, 0755, true);
}

// Chunked Upload Settings
define('CHUNK_SIZE', 2 * 1024 * 1024); // 2MB per chunk
define('TEMP_DIR', UPLOAD_DIR . 'temp/');

// Buat folder temp jika belum ada
if (!is_dir(TEMP_DIR)) {
    mkdir(TEMP_DIR, 0755, true);
}
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'javxindo_videy_user');     // Ganti dengan username MySQL Anda
define('DB_PASS', 'Akatsuki11@');     // Ganti dengan password MySQL Anda
define('DB_NAME', 'javxindo_videy_db');

// Site Configuration
define('SITE_URL', 'https://nitg.web.id'); // Ganti dengan domain Anda
define('UPLOAD_DIR', __DIR__ . '/uploads/');
define('MAX_FILE_SIZE', 200 * 1024 * 1024); // 200MB

// Allowed video formats
define('ALLOWED_FORMATS', ['video/mp4', 'video/webm', 'video/ogg', 'video/quicktime', 'video/x-msvideo']);

// Database Connection
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Helper Functions
function isLoggedIn() {
    return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function generateVideoId($length = 10) {
    return substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, $length);
}

function formatBytes($bytes, $precision = 2) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);
    $bytes /= pow(1024, $pow);
    return round($bytes, $precision) . ' ' . $units[$pow];
}
?>