<?php
// OPTIONAL: jika ingin banner dinamis, bisa ganti gambar & link di sini
$banner_image = "https://nitg.web.id/images/ads.jpg"; 
$banner_link  = "https://www.effectivegatecpm.com/wqwc0tcqb7?key=fd4e3c22f50c360ef34088775339081f";
?>

<!-- === Floating Banner === -->
<div id="floating-banner">
  <div id="banner-content">
    <button id="close-banner" disabled>Close (10)</button>
    <a href="<?php echo htmlspecialchars($banner_link); ?>" target="_blank" rel="noopener nofollow">
      <img src="<?php echo htmlspecialchars($banner_image); ?>" alt="Banner">
    </a>
  </div>
</div>

<style>
  /* --- Container utama --- */
  #floating-banner {
    position: fixed;
    left: 50%;
    bottom: 25px;
    transform: translateX(-50%);
    z-index: 99999;
    animation: fadeUp 0.5s ease;
  }

  /* --- Konten banner --- */
  #banner-content {
    position: relative;
    background: #fff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 6px 24px rgba(0,0,0,0.35);
  }

  /* --- Gambar banner --- */
  #banner-content img {
    display: block;
    width: 728px;           /* default desktop size */
    max-width: 100vw;       /* tidak lebih besar dari layar */
    height: auto;
    border-radius: 12px;
  }

  /* --- Tombol close + countdown --- */
  #close-banner {
    position: absolute;
    top: 6px;
    right: 8px;
    padding: 6px 10px;
    font-size: 14px;
    border: 0;
    border-radius: 999px;
    background: rgba(0,0,0,0.7);
    color: #fff;
    cursor: not-allowed;
    opacity: 0.85;
    pointer-events: none;
    transition: all 0.2s ease;
    z-index: 2;
  }

  #close-banner.active {
    background: rgba(0,0,0,0.9);
    cursor: pointer;
    pointer-events: auto;
    opacity: 1;
  }

  #close-banner.active:hover {
    transform: scale(1.05);
    background: rgba(255,0,0,0.9);
  }

  /* --- Animasi muncul --- */
  @keyframes fadeUp {
    from { opacity: 0; transform: translate(-50%, 40px); }
    to   { opacity: 1; transform: translate(-50%, 0); }
  }

  /* --- RESPONSIVE --- */
  @media (max-width: 1024px) {
    #banner-content img {
      width: 90vw;  /* biar lebar di tablet */
    }
  }

  @media (max-width: 768px) {
    #banner-content img {
      width: 100vw; /* lebar penuh di HP */
      border-radius: 0;
    }

    #floating-banner {
      bottom: 0; /* nempel bawah layar */
    }

    #close-banner {
      top: 10px;
      right: 12px;
      font-size: 15px;
      background: rgba(0,0,0,0.8);
    }
  }
</style>

<script>
  (function() {
    const banner = document.getElementById('floating-banner');
    const btn = document.getElementById('close-banner');
    let remaining = 10;

    btn.textContent = `Close (${remaining})`;

    const timer = setInterval(() => {
      remaining--;
      if (remaining > 0) {
        btn.textContent = `Close (${remaining})`;
      } else {
        clearInterval(timer);
        btn.textContent = '✖ Close';
        btn.classList.add('active');
        btn.disabled = false;
      }
    }, 1000);

    btn.addEventListener('click', () => {
      if (!btn.classList.contains('active')) return;
      banner.style.transition = 'opacity 0.3s ease';
      banner.style.opacity = '0';
      setTimeout(() => banner.remove(), 300);
    });
  })();
</script>
